/*****************************************************************************
*                           Freescale Semiconductor                          *
*                                                                            *
*  Project    : AN3815 - MC56F8006 Modular Pixel Matrix                      *
*  Version    : 0.1                                                          *
*  Date       : 16/Apr/2009                                                  *
*  Authors    : Alexandre Dias, Bruno Bastos                                 *
*               Humberto Carvalho, Leonardo Mangiapelo                       *
*               Renato Frias                                                 *
*                                                                            *
* -------------------------------------------------------------------------- *
* THIS SOFTWARE IS PROVIDED BY FREESCALE "AS IS" AND ANY EXPRESSED OR        *
* IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES  *
* OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.    *
* IN NO EVENT SHALL FREESCALE OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT,  *
* INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES         *
* (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR         *
* SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)         *
* HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,        * 
* STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING      *
* IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF             *
* THE POSSIBILITY OF SUCH DAMAGE.                                            *
* -------------------------------------------------------------------------- *
*  Description:                                                              *
* This software complements AN3815 - Implementing a Modular High Brightness  *
* RGB LED Network. The aim of the code is to proof the concept described on  *
* the application note document. It also serves as a starting point for      * 
* applications with MC56F8006 and some of its peripherals                    *
* -------------------------------------------------------------------------- *
*                                                                            *
*  File: pwm.c	                                                             *
*                                                                            *
*    Interfaces with PWM registers on 56F8006.								 * 
*                                                                            *
******************************************************************************/

/************************* Include Files *************************************/

#include "cpu.h"
#include "util.h"
#include "pwm.h"

/*********************** Function's Implementation ***************************/

//! Initializes PWMs.
/*! Set all PWM related functionality.*/
void pwm_init(void)
{
	int8_t i=0;
    
    
    ///////////////////////////////////////////////////////////////////////////
    // Use normal PWM output configuration
    //
    // PWM0 = GPIOA0
    // PWM1 = GPIOA1
    // PWM2 = GPIOA2
    // PWM3 = GPIOA3
    // PWM4 = GPIOA4
    // PWM5 = GPIOA5
    ///////////////////////////////////////////////////////////////////////////
    SIM_GPSA = 0;
    bitset(GPIOA_PER, BIT5+BIT4+BIT3+BIT2+BIT1+BIT0);
    
    ///////////////////////////////////////////////////////////////////////////
    // Test PWM channel swap with nBX = 0 and center aligned
    ///////////////////////////////////////////////////////////////////////////
    //  Print("CASE0: test PWM channel swap in independent mode with nBx = 0, center aligned\r\n");
    i = 1;
    pwm_reload_cnt = 0;

    PWM_CTRL &= ~(PWM_CTRL_PRSC);
    PWM_CTRL |= ((i-1) << 6);
  
    // Enable Reload Interrupts
    //PWM_CTRL |= (PWM_CTRL_PWMRIE);

	// Enable Hardware Acceleration
	PWM_CCTRL |= PWM_CCTRL_ENHA;
	PWM_CCTRL &= ~(PWM_CCTRL_nBX);
	
	// Enable swap
	PWM_CCTRL |= (PWM_CCTRL_SWP45 | PWM_CCTRL_SWP23 | PWM_CCTRL_SWP01);
	
	// Disable edge aligned
	PWM_CNFG &= ~PWM_CNFG_EDG;
	PWM_CNFG |= (PWM_CNFG_INDEP01 | PWM_CNFG_INDEP23 | PWM_CNFG_INDEP45);

    // Set PWM frequency and duty cycle and enable PWM.
    //pwm_ctrl(100, 25, 50, 75);
    // Disable PWM
    PWM_CTRL &= ~PWM_CTRL_PWMEN;
    // Disable fault protection
    PWM_DMAP1 = 0;
    PWM_DMAP2 = 0;
    // Disable deadtime generators
    PWM_DTIM0 = 0;
    PWM_DTIM1 = 0;
    // Set modulus (PWM period)
    PWM_CMOD = 300;
    // Set counter values (PWM duty cycle)
    PWM_VAL0 = 0; // PA1 - pin11 - LED 2
    PWM_VAL1 = 0; // PA0 - pin9  - LED 1
    PWM_VAL2 = 0; // PA3 - pin32 - LED 4
    PWM_VAL3 = 0; // PA2 - pin30 - LED 3
    PWM_VAL4 = 0;// PA5 - pin36 - LED 6
    PWM_VAL5 = 0;// PA4 - pin34 - LED 5
    // Enable PWM Outputs (set LDOK=1 before setting PWMEN=1)
    PWM_CTRL |= PWM_CTRL_LDOK;
    PWM_CTRL |= PWM_CTRL_PWMEN;    
    PWM_OUT = PWM_OUT_PAD_EN | PWM_OUT_OUT;
	
}


//! Set PWM values.
/*! 
	\param red - red color pwm value.
	\param green - green color pwm value.
	\param blue - blue color pwm value.
	
	Receive color values from other functions to set PWM duty cycle output.*/
void pwm_set_values(int16_t red, int16_t green, int16_t blue)
{
	PWM_VAL0=red;//red
	PWM_VAL3=green;//green
	PWM_VAL1=blue;//blue
	
	PWM_CTRL |= PWM_CTRL_LDOK;
	
}

